---
navigation:
  parent: crazyae2addons_index.md
  title: 研究系统
  icon: crazyae2addons:research_station
categories:
   - Monitoring and Automation
item_ids:
   - crazyae2addons:research_station
   - crazyae2addons:recipe_fabricator
---

# 研究系统

**研究系统**会消耗物品、能量、特殊结构以解锁高级内容和构造配方。其核心为**研究站**，且与系统相关的配方均已集成于JEI/EMI，可在其中查看。

---

## 研究站

<GameScene zoom="2" interactive={true}>
  <ImportStructure src="../assets/research_station.nbt" />
</GameScene>

- 需外部供能的多方块机器，用于**研究配方**。
- 需供应**消耗物品**、存有正确结构的**结构小帮手（诺基亚3310）**，可以选择放入**数据驱动器**。
- 随时间不断消耗**FE**和**研究流体**。
- 会向数据驱动器写入一份**解锁密钥**，后续可在**配方构造器**内合成。

---

## 研究配方

- 各研究步骤均由特殊的配方（研究配方）给定。
- 可在**JEI/EMI**中查看配方的所有需求和消耗，以及其解锁的对象。
- 配方中可能包含：
    - **持续时间**（完成研究所需刻数）
    - **每刻耗能**和**每刻流体耗量**
    - **消耗物**（研究消耗的物品）
    - **所需结构**（诺基亚3310中应当存有的结构）
    - **解锁密钥和标签**（研究成功后会写入驱动器）
    - **稳定器**（部分高级研究所需）

---

## 工作流程

1. **准备结构小帮手**
    - 使用诺基亚3310剪切存储正确的结构。
    - 如有需要，将其放入研究站。

2. **放入原材料**
    - 将所需的消耗物放入输入槽。
    - 放入数据驱动器。

3. **供应资源**
    - 向储罐注入**研究流体**。
    - 提供**FE**能源（缓存上限为25,000 FE）。

4. **开始研究**
    - 输入与有效配方对应时，研究会自动启动。
    - 可在GUI中查看研究进度。
    - 研究成功后，所存储的结构和放入的消耗品会消失，同时向驱动器写入解锁密钥。

---

## 解锁密钥与数据驱动器

- 密钥存储于数据驱动器。
- 研究站会自动将密钥写入驱动器。
- 驱动器可以复制：将存有需复制密钥的驱动器放入输入槽，再将目标驱动器放入驱动器槽，即会为目标驱动器**补齐缺失的密钥**（消耗研究流体、能量，且需等待）。

---

## 构造集成

- **配方构造器**的配方需对应的密钥解锁。
- 驱动器中若无对应密钥，便不会启动构造配方。
- 换言之，研究是高级合成的前置需求。

---

## 关键特性

- **JEI/EMI集成** – 所有研究/构造配方均可在配方浏览器内查看。
- **结构校验** – 确保你扫描的结构正确无误。
- **随时间消耗能量和流体** – 研究要有物质基础支撑。
- **基于驱动器的解锁系统** – 研究进度可在多台机器间复制。
- **驱动器对驱动器复制** – 合并不同驱动器的解锁密钥。
